﻿using Microsoft.Office.Tools.Ribbon;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.IO;
using System.Diagnostics;
using Microsoft.Office.Interop;


namespace Excel自动保存
{
    public partial class Ribbon1
    {
        private void Ribbon1_Load(object sender, RibbonUIEventArgs e)
        {
        }

        private void 选择框_启动自动保存_Click(object sender, RibbonControlEventArgs e)
        {
            if (选择框_启动自动保存.Checked == true) //启动程序
            {
                时钟1.Enabled = true;
                IniFile f = new IniFile(System.AppDomain.CurrentDomain.BaseDirectory + "XLSSavePlus.ini");
                f.WriteContentValue("首选项", "启动", "1");
                if (保存原始文件.Checked == true) { 时钟3.Enabled = true; } else { 时钟3.Enabled = false; }
                if (启动永久.Checked == true) { 时钟2.Enabled = true; } else { 时钟2.Enabled = false; }
            }
            else
            {
                时钟1.Enabled = false;
                IniFile f = new IniFile(System.AppDomain.CurrentDomain.BaseDirectory + "XLSSavePlus.ini");
                f.WriteContentValue("首选项", "启动", "0");
                时钟3.Enabled = false;
                时钟2.Enabled = false;
            }

        }

        private void 打开保存文件夹_Click(object sender, RibbonControlEventArgs e)
        {
            Process.Start("explorer.exe", 全局变量.临时保存文件夹);

        }

        private void 设置_Click(object sender, RibbonControlEventArgs e)
        {
            if (文件数.Enabled == false)
            {
                文件数.Enabled = true;
                间隔时间.Enabled = true;
                保存位置.Enabled = true;
                启动永久.Enabled = true;
                永久保存间隔.Enabled = true;
                保存原始文件.Enabled = true;
                打开配置文件.Enabled = true;
            }
            else
            {
                文件数.Enabled = false;
                间隔时间.Enabled = false;
                保存位置.Enabled = false;
                启动永久.Enabled = false;
                永久保存间隔.Enabled = false;
                保存原始文件.Enabled = false;
                打开配置文件.Enabled = false;

            }

        }

        private void 文件数_TextChanged(object sender, RibbonControlEventArgs e)
        {
            全局变量.临时文件个数 = int.Parse(文件数.Text);
            IniFile f = new IniFile(System.AppDomain.CurrentDomain.BaseDirectory + "XLSSavePlus.ini");
            f.WriteContentValue("首选项", "保存文件数", 全局变量.临时文件个数.ToString());

        }

        private void 间隔时间_TextChanged(object sender, RibbonControlEventArgs e)
        {
            int x = 30000;
            if (间隔时间.Text == "30秒") { x = 30000; }
            else if (间隔时间.Text == "1分钟") { x = 60000; }
            else if (间隔时间.Text == "1分30秒") { x = 90000; }
            else if (间隔时间.Text == "2分钟") { x = 120000; }
            else if (间隔时间.Text == "2分30秒") { x = 150000; }
            else if (间隔时间.Text == "3分钟") { x = 180000; }
            else if (间隔时间.Text == "3分30秒") { x = 210000; }
            else if (间隔时间.Text == "4分钟") { x = 240000; }
            else if (间隔时间.Text == "4分30秒") { x = 270000; }
            else if (间隔时间.Text == "5分钟") { x = 300000; }
            时钟1.Interval = x;
            IniFile f = new IniFile(System.AppDomain.CurrentDomain.BaseDirectory + "XLSSavePlus.ini");
            f.WriteContentValue("首选项", "保存时间间隔", x.ToString());
        }

        private void 保存位置_Click(object sender, RibbonControlEventArgs e)
        {
            文件夹对话框.SelectedPath = 全局变量.临时保存文件夹;
            文件夹对话框.Description = "当前保存位置：" + "\r\n" + 全局变量.临时保存文件夹;
            if (文件夹对话框.ShowDialog() == DialogResult.OK)
            {
                //MessageBox.Show(文件夹对话框.SelectedPath);
                全局变量.临时保存文件夹 = 文件夹对话框.SelectedPath + "\\XLSsave\\";
                System.IO.Directory.CreateDirectory(全局变量.临时保存文件夹);
                IniFile f = new IniFile(System.AppDomain.CurrentDomain.BaseDirectory + "XLSSavePlus.ini");
                f.WriteContentValue("首选项", "路径", 全局变量.临时保存文件夹);
            }

        }

        private void 启动永久_Click(object sender, RibbonControlEventArgs e)
        {
            if (启动永久.Checked == true)
            {
                时钟2.Enabled = true;
                IniFile f = new IniFile(System.AppDomain.CurrentDomain.BaseDirectory + "XLSSavePlus.ini");
                f.WriteContentValue("首选项", "永久保存文件", "1");
            }
            else
            {
                时钟2.Enabled = false;
                IniFile f = new IniFile(System.AppDomain.CurrentDomain.BaseDirectory + "XLSSavePlus.ini");
                f.WriteContentValue("首选项", "永久保存文件", "0");
            }

        }

        private void 永久保存间隔_TextChanged(object sender, RibbonControlEventArgs e)
        {
            int x = 9000000;
            if (永久保存间隔.Text == "30分钟") { x = 1800000; }
            else if (永久保存间隔.Text == "1小时") { x = 3600000; }
            else if (永久保存间隔.Text == "1小时30分钟") { x = 5400000; }
            else if (永久保存间隔.Text == "2小时") { x = 7200000; }
            else if (永久保存间隔.Text == "2小时30分钟") { x = 9000000; }
            else if (永久保存间隔.Text == "3小时") { x = 10800000; }
            else if (永久保存间隔.Text == "3小时30分钟") { x = 12600000; }
            else if (永久保存间隔.Text == "4小时") { x = 14400000; }
            else if (永久保存间隔.Text == "4小时30分钟") { x = 16200000; }
            else if (永久保存间隔.Text == "5小时") { x = 18000000; }
            时钟2.Interval = x;
            IniFile f = new IniFile(System.AppDomain.CurrentDomain.BaseDirectory + "XLSSavePlus.ini");
            f.WriteContentValue("首选项", "永久文件间隔", x.ToString());

        }

        private void 保存原始文件_Click(object sender, RibbonControlEventArgs e)
        {
            if (保存原始文件.Checked == true)
            {
                时钟3.Enabled = true;
                IniFile f = new IniFile(System.AppDomain.CurrentDomain.BaseDirectory + "XLSSavePlus.ini");
                f.WriteContentValue("首选项", "保存原始文件", "1");
            }
            else
            {
                时钟3.Enabled = false;
                IniFile f = new IniFile(System.AppDomain.CurrentDomain.BaseDirectory + "XLSSavePlus.ini");
                f.WriteContentValue("首选项", "保存原始文件", "0");
            }
        }

        private void 按钮_帮助_Click(object sender, RibbonControlEventArgs e)
        {
            弹窗说明 u = new 弹窗说明();
            u.ShowDialog();
        }

        private void 打开配置文件_Click(object sender, RibbonControlEventArgs e)
        {
            System.Diagnostics.Process.Start("notepad.exe", System.AppDomain.CurrentDomain.BaseDirectory + "XLSSavePlus.ini");
        }

        private void 时钟1_Tick(object sender, EventArgs e)
        {
            Microsoft.Office.Interop.Excel.Application Excel程序 = (Microsoft.Office.Interop.Excel.Application)System.Runtime.InteropServices.Marshal.GetActiveObject("Excel.Application");//挂勾当前EXCEL程序
            Microsoft.Office.Interop.Excel.Workbooks Excel文档集 = Excel程序.Workbooks;//设excel文件集
            if (Excel文档集.Count == 0)//如果文件集为空
            { return; }
            foreach (Microsoft.Office.Interop.Excel.Workbook 文档变量 in Excel文档集)//对每个文件进行设置
            {
                string 文件路径 = null;
                string 文件名称 = null;
                //Microsoft.Office.Core.MsoTriState savefalse = Microsoft.Office.Core.MsoTriState.msoFalse;
                if (!文档变量.Saved)//如保文件修改过
                {
                    int x = 文档变量.FullName.LastIndexOf("\\");//查找文件名是的文件和文件夹分割号，倒找单斜杠
                    if (x != -1)//找到分割号
                    {
                        文件路径 = 文档变量.FullName.Substring(0, x + 1);
                        文件名称 = 文档变量.FullName.Substring(x + 1);
                    }
                    else
                    {
                        文件路径 = null;
                        文件名称 = 文档变量.FullName + ".xlsx";
                    }

                    string[] 保存文件夹数组 = 全局变量.临时保存文件夹.Split('\\');//对保存文件夹进行分段，分出每一层
                    string b = null;
                    foreach (string a in 保存文件夹数组)//准备对每一层文件夹是否存在进行查找并建立
                    {
                        if (a != "\\") { b = b + a + "\\"; }
                        if (!Directory.Exists(b))//查有电脑是是否存在需要保存的临时文件夹
                        {
                            System.IO.Directory.CreateDirectory(b);
                        }
                    }
                    if (!Directory.Exists(全局变量.临时保存文件夹 + 文件名称 + "\\"))//建立与名字相关的文件夹
                    { System.IO.Directory.CreateDirectory(全局变量.临时保存文件夹 + 文件名称 + "\\"); }
                    for (int y = 1; y <= 全局变量.临时文件个数; y++)//根据设置的保存临时文件个数，确认是否存在并删除新建
                    {
                        if (y == 全局变量.临时文件个数 && File.Exists(全局变量.临时保存文件夹 + 文件名称 + "\\" + y.ToString() + 文件名称))//已达到最大个数，并且最大个数文件存在
                        {
                            for (int z = 1; z <= 全局变量.临时文件个数; z++)//再次循环，删除第一个文件，并把之后的文件改小一个值，以空最后的文件，用于保存
                            {
                                if (z == 1) { File.Delete(全局变量.临时保存文件夹 + 文件名称 + "\\" + z.ToString() + 文件名称); }//删除每一个，最早的文件
                                else { File.Move(全局变量.临时保存文件夹 + 文件名称 + "\\" + z.ToString() + 文件名称, 全局变量.临时保存文件夹 + 文件名称 + "\\" + (z - 1).ToString() + 文件名称); }//其他的文件改小一个值
                                if (z == 全局变量.临时文件个数)//当是最大文件时，之前已经被改名，所以下面就新建。
                                {
                                    文档变量.SaveCopyAs(全局变量.临时保存文件夹 + 文件名称 + "\\" + z.ToString() + 文件名称);//保存附本，与原文无关
                                    //文档变量.SaveAs(全局变量.临时保存文件夹 + 文件名称 + "\\" + z.ToString() + 文件名称);
                                    //if (文件路径 != null && 文件路径 != 全局变量.临时保存文件夹 + 文件名称 + "\\")
                                    //{ 文档变量.SaveAs(文件路径 + 文件名称); }
                                    //else { 文档变量.SaveAs(全局变量.临时保存文件夹 + 文件名称 + "\\" + 文件名称); }
                                }
                            }
                        }
                        else if (!File.Exists(全局变量.临时保存文件夹 + 文件名称 + "\\" + y.ToString() + 文件名称))//如果没有达到最大文件要求数，并且没有找到文件（如果找到文件就忽略，找更高值）
                        {
                            文档变量.SaveCopyAs(全局变量.临时保存文件夹 + 文件名称 + "\\" + y.ToString() + 文件名称);
                            //文档变量.SaveAs(全局变量.临时保存文件夹 + 文件名称 + "\\" + y.ToString() + 文件名称);

                            //if (文件路径 != null && 文件路径 != 全局变量.临时保存文件夹 + 文件名称 + "\\")
                            //{ 文档变量.SaveAs(文件路径 + 文件名称); }
                            //else { 文档变量.SaveAs(全局变量.临时保存文件夹 + 文件名称 + "\\" + 文件名称); }
                            break;
                        }
                    }
                }
            }

        }

        private void 时钟2_Tick(object sender, EventArgs e)
        {
            if (全局变量.永久保存识别码 == 0) { 全局变量.永久保存识别码 = 1; return; }//如果是第一次，并不进行永远保存，只是把识别码改成1
            Microsoft.Office.Interop.Excel.Application Excel程序 = (Microsoft.Office.Interop.Excel.Application)System.Runtime.InteropServices.Marshal.GetActiveObject("Excel.Application");
            Microsoft.Office.Interop.Excel.Workbooks Excel文档集 = Excel程序.Workbooks;
            if (Excel文档集.Count == 0)
            {
                return;
            }
            foreach (Microsoft.Office.Interop.Excel.Workbook 文档变量 in Excel文档集)//对每个文件进行检查
            {
                string 文件路径 = null;
                string 文件名称 = null;
                int x = 文档变量.FullName.LastIndexOf("\\");//查找文件名是的文件和文件夹分割
                if (x != -1)//找到
                {
                    文件路径 = 文档变量.FullName.Substring(0, x + 1);
                    文件名称 = 文档变量.FullName.Substring(x + 1);
                }
                else
                {
                    文件路径 = null;
                    文件名称 = 文档变量.FullName + ".xlsx";
                }
                string[] 保存文件夹数组 = 全局变量.临时保存文件夹.Split('\\');
                string b = null;
                foreach (string a in 保存文件夹数组)
                {
                    if (a != "\\") { b = b + a + "\\"; }
                    if (!Directory.Exists(b))//查有电脑是是否存在需要保存的临时文件夹
                    {
                        System.IO.Directory.CreateDirectory(b);
                    }
                }
                if (!Directory.Exists(全局变量.临时保存文件夹 + 文件名称 + "\\"))//建立与名字相关的文件夹
                {
                    System.IO.Directory.CreateDirectory(全局变量.临时保存文件夹 + 文件名称 + "\\");
                }
                if (文件路径 != null && 文件路径 != 全局变量.临时保存文件夹 + 文件名称 + "\\")
                {
                    文档变量.SaveCopyAs(全局变量.临时保存文件夹 + 文件名称 + "\\" + "永久保存" + DateTime.Now.ToString("yyyyMMdd") + DateTime.Now.ToString("hhmmss") + 文件名称);
                    //文档变量.SaveAs(全局变量.临时保存文件夹 + 文件名称 + "\\" + "永久保存" + DateTime.Now.ToString("yyyyMMdd") + DateTime.Now.ToString("hhmmss") + 文件名称);
                    //文档变量.SaveAs(文件路径 + 文件名称);
                }

            }

        }

        private void 时钟3_Tick(object sender, EventArgs e)
        {
            Microsoft.Office.Interop.Excel.Application Excel程序 = (Microsoft.Office.Interop.Excel.Application)System.Runtime.InteropServices.Marshal.GetActiveObject("Excel.Application");
            Microsoft.Office.Interop.Excel.Workbooks Excel文档集 = Excel程序.Workbooks;
            if (Excel文档集.Count == 0){return;}
            List<string> 临时 = new List<string>();
            if (全局变量.文件名合集 == null)//第一次运行
            {
                foreach (Microsoft.Office.Interop.Excel.Workbook Excel文档 in Excel文档集)
                {
                    临时.Add(Excel文档.FullName);//把文件名导入“临时”变量集
                }
                string[] 临时文档名集合变量 = 临时.ToArray();//转到数组集合，用于集合操作
                全局变量.文件名合集 = 临时.ToArray();//把当前打开的文件名转给全局变量，以备第二次及以后使用
                for (int x = 0; x < 临时文档名集合变量.Length; x++)//对每个文件名进行验证
                {
                    string 文件路径 = null;
                    string 文件名称 = null;
                    int y = 临时文档名集合变量[x].LastIndexOf("\\");//查找文件名是的文件和文件夹分割
                    if (y != -1 && 临时文档名集合变量[x].Substring(0, y + 1) != 全局变量.临时保存文件夹 + 临时文档名集合变量[x].Substring(y + 1))//找到
                    {
                        文件路径 = 临时文档名集合变量[x].Substring(0, y + 1);
                        文件名称 = 临时文档名集合变量[x].Substring(y + 1);
                        string[] 保存文件夹数组 = 全局变量.临时保存文件夹.Split('\\');
                        string b = null;
                        foreach (string a in 保存文件夹数组)
                        {
                            if (a != "\\") { b = b + a + "\\"; }
                            if (!Directory.Exists(b))//查有电脑是是否存在需要保存的临时文件夹
                            {
                                System.IO.Directory.CreateDirectory(b);
                            }
                        }
                        if (!Directory.Exists(全局变量.临时保存文件夹 + 文件名称 + "\\"))//建立与名字相关的文件夹
                        {
                            System.IO.Directory.CreateDirectory(全局变量.临时保存文件夹 + 文件名称 + "\\");
                        }
                        foreach (Microsoft.Office.Interop.Excel.Workbook Excel文档 in Excel文档集)
                        {
                            if (临时文档名集合变量[x] == Excel文档.FullName)
                            {
                                Excel文档.SaveCopyAs(全局变量.临时保存文件夹 + 文件名称 + "\\" + "疑似原始文件" + DateTime.Now.ToString("yyyyMMdd") + DateTime.Now.ToString("hhmmss") + 文件名称);
                                //Excel文档.SaveAs(全局变量.临时保存文件夹 + 文件名称 + "\\" + "疑似原始文件" + DateTime.Now.ToString("yyyyMMdd") + DateTime.Now.ToString("hhmmss") + 文件名称);
                                //Excel文档.SaveAs(临时文档名集合变量[x]);
                            }
                        }

                    }
                }
            }
            else
            {
                foreach (Microsoft.Office.Interop.Excel.Workbook Excel文档 in Excel文档集)
                {
                    临时.Add(Excel文档.FullName);
                }
                string[] 临时文档名集合变量 = 临时.ToArray();
                string[] 结果集合 = 临时文档名集合变量.Except(全局变量.文件名合集).ToArray();//对两数组进行比较，取到新的打开的文件
                if (结果集合.Length == 0) { return; }
                for (int x = 0; x < 结果集合.Length; x++)
                {
                    string 文件路径 = null;
                    string 文件名称 = null;
                    int y = 结果集合[x].LastIndexOf("\\");//查找文件名是的文件和文件夹分割
                    if (y != -1 && 结果集合[x].Substring(0, y + 1) != 全局变量.临时保存文件夹 + 结果集合[x].Substring(y + 1))//找到
                    {
                        文件路径 = 结果集合[x].Substring(0, y + 1);
                        文件名称 = 结果集合[x].Substring(y + 1);
                        string[] 保存文件夹数组 = 全局变量.临时保存文件夹.Split('\\');
                        string b = null;
                        foreach (string a in 保存文件夹数组)
                        {
                            if (a != "\\") { b = b + a + "\\"; }
                            if (!Directory.Exists(b))//查有电脑是是否存在需要保存的临时文件夹
                            {
                                System.IO.Directory.CreateDirectory(b);
                            }
                        }
                        if (!Directory.Exists(全局变量.临时保存文件夹 + 文件名称 + "\\"))//建立与名字相关的文件夹
                        {
                            System.IO.Directory.CreateDirectory(全局变量.临时保存文件夹 + 文件名称 + "\\");
                        }
                        foreach (Microsoft.Office.Interop.Excel.Workbook Excel文档 in Excel文档集)
                        {
                            if (结果集合[x] == Excel文档.FullName)
                            {
                                Excel文档.SaveCopyAs(全局变量.临时保存文件夹 + 文件名称 + "\\" + "疑似原始文件" + DateTime.Now.ToString("yyyyMMdd") + DateTime.Now.ToString("hhmmss") + 文件名称);
                                //Excel文档.SaveAs(全局变量.临时保存文件夹 + 文件名称 + "\\" + "疑似原始文件" + DateTime.Now.ToString("yyyyMMdd") + DateTime.Now.ToString("hhmmss") + 文件名称);
                                //Excel文档.SaveAs(结果集合[x]);
                            }
                        }

                    }
                }
                全局变量.文件名合集 = 临时.ToArray();//将文件名导入全局变量中，以下一次进行比较

            }

        }
    }
}
